******************************************************************************************************************
* Disability employment results WITHOUT bootstrap
* This can't do PPWD (without getting SUEST to work), nor the full randomness for predicted dis - but otherwise correct
* This application started 4/8/2023
******************************************************************************************************************

// The analysis
local measures "${disvar} ${IRTvar} ${predictedvar}_fxd ${predictedvar}"
foreach measure in `measures' {

	* Models 1 - DISABILITY differences betweeen surveys
	eststo d1_`measure'		: logit `measure'  i.${countryvar}##i.wave				$controls $controls2 				[pw=${pweight}]
		testparm i.countrynum#3.wave		// check against the joint sig test of margins below
			estadd scalar alltest_p 	= `r(p)'		: d1_`measure'
		eststo dMr_`measure' :	margins r.wave@${countryvar}, 			 at(${controlsmeans}) post
			estadd scalar jointsig = e(p)[1,colsof(e(p))]		: dMr_`measure'			// for joint significance
	
	* Models 2 - the levels in each survey in each country
	eststo dw2_`measure'		: logit `measure'  i.${countryvar}						$controls $controls2 if	wave==2 [pw=${pweight}]
		eststo dMw2_`measure' :	margins i.${countryvar}, 				 at(${controlsmeans}) post
	eststo dw3_`measure'		: logit `measure'  i.${countryvar}						$controls $controls2 if wave==3 [pw=${pweight}]
		eststo dMw3_`measure' :	margins i.${countryvar}, 				 at(${controlsmeans}) post
	
	* Models 3 - DIS EMPLOYMENT differences between surveys
	// GAP
	eststo e3_`measure'		: logit ${empvar}  ib(1).`measure'##i.${countryvar}##i.wave 	$controls $controls2  	 	[pw=${pweight}]
		testparm i.countrynum#i.`measure'#i.wave // check against the joint sig test of margins below
			estadd scalar alltest_p 	= `r(p)'		: e3_`measure'
		eststo eMrr_`measure':	margins r.`measure'#r.wave@${countryvar}, 		 at(${eurpop} ${controlsmeans}) post
			estadd scalar jointsig = e(p)[1,colsof(e(p))]		: eMrr_`measure'		// for joint significance
	// ABSOLUTE DISEMP
	estimates restore e3_`measure'
		eststo eMer_`measure':	margins r.wave@1.`measure'#${countryvar}, 		 at(${eurpop} ${controlsmeans}) post
			estadd scalar jointsig = e(p)[1,colsof(e(p))]		: eMer_`measure'		// for joint significance
	
	* Models 4 - DIS EMPLOYMENT absolute levels
	eststo ew2_`measure'		: logit ${empvar}  ib(1).`measure'##i.${countryvar}  $controls $controls2 if wave==2 	[pw=${pweight}]
		eststo eMiw2_`measure':	margins i.`measure', over(${countryvar}) at(${eurpop} ${controlsmeans}) post
		estimates restore ew2_`measure'
		eststo eMrw2_`measure':	margins r.`measure'@${countryvar}, 		 at(${eurpop} ${controlsmeans}) post
	eststo ew3_`measure'		: logit ${empvar}  ib(1).`measure'##i.${countryvar}  $controls $controls2 if wave==3 	[pw=${pweight}]
		eststo eMiw3_`measure':	margins i.`measure', over(${countryvar}) at(${eurpop} ${controlsmeans}) post
		estimates restore ew3_`measure'
		eststo eMrw3_`measure':	margins r.`measure'@${countryvar}, 		 at(${eurpop} ${controlsmeans}) post
	
	* NOTE: this all uses over($countryvar), which is different to 5_results_bootstrap.do. Will produce the same results unless the covariates are not set to fixed values in 'at'.

/**/							}


// The tables
numlabel ${countryvar}, mask(#_) remove
levelsof ${countryvar}
foreach country in `r(levels)'	{
	* Renaming the variables from four equations so that they display in the same rows
	local countrylab: label (${countryvar}) `country'
	local countrylab = subinstr("`countrylab'", " ", "_", .)		// estttab, rename() doesn't work with spaces, so need to remove this, and use the 'varlabels' option to insert the space back in
	local rename_eMrr `"`rename_eMrr' r1vs0.${disvar}#r3vs2.wave@`country'.${countryvar}  "`countrylab'" "'
	local rename_eMrr `"`rename_eMrr' r1vs0.${IRTvar}#r3vs2.wave@`country'.${countryvar}  "`countrylab'" "'
	local rename_eMrr `"`rename_eMrr' r1vs0.${predictedvar}_fxd#r3vs2.wave@`country'.${countryvar}  "`countrylab'" "'
	local rename_eMrr `"`rename_eMrr' r1vs0.${predictedvar}#r3vs2.wave@`country'.${countryvar}  "`countrylab'" "'
	local rename_eMer `"`rename_eMer' r3vs2.wave@1.${disvar}#`country'.${countryvar}  "`countrylab'" "'
	local rename_eMer `"`rename_eMer' r3vs2.wave@1.${IRTvar}#`country'.${countryvar}  "`countrylab'" "'
	local rename_eMer `"`rename_eMer' r3vs2.wave@1.${predictedvar}_fxd#`country'.${countryvar}  "`countrylab'" "'
	local rename_eMer `"`rename_eMer' r3vs2.wave@1.${predictedvar}#`country'.${countryvar}  "`countrylab'" "'
	local rename_eMr `"`rename_eMr' r1vs0.${disvar}@`country'.${countryvar} "`countrylab'" "'
	local rename_eMr `"`rename_eMr' r1vs0.${IRTvar}@`country'.${countryvar} "`countrylab'" "'
	local rename_eMr `"`rename_eMr' r1vs0.${predictedvar}@`country'.${countryvar} "`countrylab'" "'
	local rename_eMr `"`rename_eMr' r1vs0.${predictedvar}_fxd@`country'.${countryvar} "`countrylab'" "'
	local rename_eMi `"`rename_eMi' `country'.${countryvar}#1.${disvar} "`countrylab'" "'
	local rename_eMi `"`rename_eMi' `country'.${countryvar}#1.${IRTvar} "`countrylab'" "'
	local rename_eMi `"`rename_eMi' `country'.${countryvar}#1.${predictedvar} "`countrylab'" "'
	local rename_eMi `"`rename_eMi' `country'.${countryvar}#1.${predictedvar}_fxd "`countrylab'" "'
	local rename_dM  `"`rename_dM' `country'.${countryvar} "`countrylab'" "'
	local rename_dMr `"`rename_dMr' r3vs2.wave@`country'.${countryvar} "`countrylab'" "'
/**/							}
numlabel ${countryvar}, mask(#_) add
* The ESTTAB command
global esttabopts `"nostar b(%3.1f) ci(%3.1f) transform(@*100 100) varwidth(20) modelwidth(8 15 8 15 8 15 8 15)"'
global esttabopts `"${esttabopts} varlabels("UK" "UK(w2)/England(w3)") coeflabels(`labels') nonum replace nolegend nobaselevels wide"'
global esttabopts `"${esttabopts} mtitles(LLSI Factor "Predicted (fixed)" "Predicted (random)")  mgroups("Observed" "Alternative measures", pattern(1 1 0 0))"'			 
global esttabopts `"${esttabopts} order("Liberal" UK "Social Democratic A" DK "Social Democratic B" NO SE "Corporatist-A" AT HU "Corporatist-B" PL LU "Corporatist-C" CZ SI SK "Southern" IT EL "Other" IS EE LT LV HR BG RO CY MT)"' 
global esttabopts `"${esttabopts} addnotes("Table created on `c(current_date)'" "INSTRUCTIONS FOR FORMATTING: headings into bold, change font & size, reduce size for CI cols, merge titles, remove internal margins, then double-click to reduce width of cols, under table style")"'
* Outputting to Word tables
esttab eMrw3_* using "${dodir}\Outputs\1.nonbootstrap_empR_w3.rtf", ${esttabopts} rename(`rename_eMr' ) title("Disability employment gap (w3-SHARE)")
esttab eMiw3_* using "${dodir}\Outputs\1.nonbootstrap_empM_w3.rtf", ${esttabopts} rename(`rename_eMi' ) title("Disability employment rate (w3-SHARE)") drop (*0.${disvar}*)
esttab eMrw2_* using "${dodir}\Outputs\1.nonbootstrap_empR_w2.rtf", ${esttabopts} rename(`rename_eMr' ) title("Disability employment gap (w2)")
esttab eMiw2_* using "${dodir}\Outputs\1.nonbootstrap_empM_w2.rtf", ${esttabopts} rename(`rename_eMi' ) title("Disability employment rate (w2)") drop (*0.${disvar}*)
esttab eMrr_* 	 using "${dodir}\Outputs\1.nonbootstrap_empRtrend.rtf"	  , ${esttabopts} rename(`rename_eMrr') title("Trend (w3 vs. w2) differences in disability employment gap") scalars(jointsig) sfmt(%5.4f)
esttab eMer_* 	 using "${dodir}\Outputs\1.nonbootstrap_empMtrend.rtf"	  , ${esttabopts} rename(`rename_eMer') title("Trend (w3 vs. w2) differences in disability employment level") scalars(jointsig) sfmt(%5.4f)
esttab dMw3_*  using "${dodir}\Outputs\1.nonbootstrap_disR_w3.rtf", ${esttabopts} rename(`rename_dM'  ) title("Disability rate (w3-SHARE)")
esttab dMw2_*  using "${dodir}\Outputs\1.nonbootstrap_disR_w2.rtf", ${esttabopts} rename(`rename_dM'  ) title("Disability rate (w2)")
esttab dMr_*  	 using "${dodir}\Outputs\1.nonbootstrap_disRtrend.rtf"	  , ${esttabopts} rename(`rename_dMr' ) title("Trend (w3 vs. w2) differences in disability rate")			  scalars(jointsig) sfmt(%5.4f)
/* Outputting to Tab-delimited for importing into Excel
esttab eMr_* using "${dodir}\Outputs\1.nonbootstrap_empR.tab", ${esttabopts} rename(`rename_eMr' ) title("Disability employment gap")
esttab eMi_* using "${dodir}\Outputs\1.nonbootstrap_empM.tab", ${esttabopts} rename(`rename_eMi' ) title("Disability employment rate") drop (*0.${disvar}*)
esttab dM_*  using "${dodir}\Outputs\1.nonbootstrap_disR.tab" , ${esttabopts} rename(`rename_dM' ) title("Disability rate")
*/
	
